/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class DisplayBlockEntityRenderer
implements BlockEntityRenderer<DisplayBlockEntity> {
    private static final double TEXT_RENDER_DISTANCE = 225.0;

    public void render(DisplayBlockEntity entity, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        double platformY;
        if (!entity.isBottomDisplay() || !entity.getInputBlockEntity().hasGroup()) {
            return;
        }
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
        int height = entity.hasDisplayOnTop() ? 2 : 1;
        Level level = entity.m_58904_();
        Direction facing = entity.getFacing();
        ElevatorGroup group = entity.getElevatorGroup();
        BlockPos frontPos = entity.m_58899_().m_142300_(facing);
        if (height == 1) {
            combinedLight = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)frontPos);
        } else if (level.m_8055_(frontPos).m_60788_((BlockGetter)level, frontPos) || level.m_8055_(frontPos.m_7494_()).m_60788_((BlockGetter)level, frontPos.m_7494_())) {
            combinedLight = 0xF000F0;
        } else {
            int skyLight = Math.max(level.m_45517_(LightLayer.SKY, frontPos), level.m_45517_(LightLayer.SKY, frontPos.m_7494_()));
            int blockLight = Math.max(level.m_45517_(LightLayer.BLOCK, frontPos), level.m_45517_(LightLayer.BLOCK, frontPos.m_7494_()));
            int blockStateLight = Math.max(level.m_8055_(frontPos).getLightEmission((BlockGetter)level, frontPos), level.m_8055_(frontPos.m_7494_()).getLightEmission((BlockGetter)level, frontPos.m_7494_()));
            blockLight = Math.max(blockLight, blockStateLight);
            combinedLight = skyLight << 20 | blockLight << 4;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85845_(new Quaternion(0.0f, 180.0f - facing.m_122435_(), 0.0f, true));
        matrixStack.m_85837_(-0.5, -0.5, -0.51);
        if (height == 1) {
            this.drawOverlayPart(matrixStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, 0, 32, 32);
        } else {
            this.drawOverlayPart(matrixStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 2.0f, 32, 0, 32, 64);
        }
        int index = group.getFloorNumber(entity.getInputBlockEntity().getFloorLevel());
        int button_count = height == 1 ? 3 : 7;
        int below = index;
        int above = group.getFloorCount() - index - 1;
        if (below < above) {
            below = Math.min(below, button_count);
            above = Math.min(above, button_count * 2 - below);
        } else {
            above = Math.min(above, button_count);
            below = Math.min(below, button_count * 2 - above);
        }
        int startIndex = index - below;
        int total = below + 1 + above;
        Vec3 buttonPos = new Vec3((double)entity.m_58899_().m_123341_() + 0.5, (double)entity.m_58899_().m_123342_() + 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0, (double)entity.m_58899_().m_123343_() + 0.5);
        Vec3 cameraPos = RenderUtils.getCameraPosition();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0, -0.002);
        matrixStack.m_85841_(1.0f, 0.125f, 1.0f);
        for (int i = 0; i < total; ++i) {
            boolean drawText;
            DyeColor labelColor = group.getFloorDisplayColor(startIndex + i);
            this.drawOverlayPart(matrixStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, startIndex + i == index ? 96 : 64, labelColor.m_41060_() * 4, 32, 4);
            boolean bl = drawText = cameraPos.m_82557_(buttonPos) < 225.0;
            if (drawText) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.578125, 0.0, 0.0);
                this.drawString(matrixStack, bufferSource, combinedLight, MovingElevatorsClient.formatFloorDisplayName(group.getFloorDisplayName(startIndex + i), startIndex + i));
                matrixStack.m_85849_();
            }
            matrixStack.m_85837_(0.0, 1.0, 0.0);
            buttonPos = buttonPos.m_82520_(0.0, 0.125, 0.0);
        }
        matrixStack.m_85849_();
        if (group.isMoving() && (platformY = group.getCurrentY()) >= (double)group.getFloorYLevel(0) && platformY < (double)group.getFloorYLevel(group.getFloorCount() - 1)) {
            double yOffset = 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0;
            for (int i = 0; i < group.getFloorCount() - 1; ++i) {
                int belowY = group.getFloorYLevel(i);
                int aboveY = group.getFloorYLevel(i + 1);
                if (!(platformY >= (double)belowY) || !(platformY < (double)aboveY)) continue;
                yOffset += ((double)i + (platformY - (double)belowY) / (double)(aboveY - belowY)) * 0.125;
            }
            matrixStack.m_85837_(0.078125, yOffset, -0.003);
            matrixStack.m_85841_(0.125f, 0.125f, 1.0f);
            this.drawOverlayPart(matrixStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, 32, 10, 10);
        }
        matrixStack.m_85849_();
    }

    private void drawOverlayPart(PoseStack matrixStack, VertexConsumer buffer, int combinedLight, int combinedOverlay, Direction facing, float x, float y, float width, float height, int tX, int tY, int tWidth, int tHeight) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        Matrix3f normalMatrix = matrixStack.m_85850_().m_85864_();
        float minU = MovingElevatorsClient.OVERLAY_SPRITE.m_118367_((double)((float)tX / 8.0f));
        float maxU = MovingElevatorsClient.OVERLAY_SPRITE.m_118367_((double)((float)(tX + tWidth) / 8.0f));
        float minV = MovingElevatorsClient.OVERLAY_SPRITE.m_118393_((double)((float)tY / 8.0f));
        float maxV = MovingElevatorsClient.OVERLAY_SPRITE.m_118393_((double)((float)(tY + tHeight) / 8.0f));
        buffer.m_85982_(matrix, x, y + height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(maxU, minV).m_85969_(combinedLight).m_85977_(normalMatrix, (float)facing.m_122429_(), (float)facing.m_122430_(), (float)facing.m_122431_()).m_86008_(combinedOverlay).m_5752_();
        buffer.m_85982_(matrix, x + width, y + height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(minU, minV).m_85969_(combinedLight).m_85977_(normalMatrix, (float)facing.m_122429_(), (float)facing.m_122430_(), (float)facing.m_122431_()).m_86008_(combinedOverlay).m_5752_();
        buffer.m_85982_(matrix, x + width, y, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_85969_(combinedLight).m_85977_(normalMatrix, (float)facing.m_122429_(), (float)facing.m_122430_(), (float)facing.m_122431_()).m_86008_(combinedOverlay).m_5752_();
        buffer.m_85982_(matrix, x, y, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_85969_(combinedLight).m_85977_(normalMatrix, (float)facing.m_122429_(), (float)facing.m_122430_(), (float)facing.m_122431_()).m_86008_(combinedOverlay).m_5752_();
    }

    private void drawString(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, String s) {
        if (s == null) {
            return;
        }
        Font fontRenderer = ClientUtils.getMinecraft().f_91062_;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.07, -0.005);
        matrixStack.m_85841_(-0.01f, -0.08f, 1.0f);
        float f = (float)(-fontRenderer.m_92895_(s)) / 2.0f;
        Objects.requireNonNull(fontRenderer);
        fontRenderer.m_92883_(matrixStack, s, f, (float)(-9), -1);
        matrixStack.m_85849_();
    }
}

